<?php
  BEvent::Hook('notify', array('Notifier', 'ToFile'));
  BEvent::Hook('notify', array('Notifier', 'ToEMail'));

/* one-shot */
  $this->name = 'notifier';
  $this->Caption('Оповещатель', 'ru');
  $this->info['user files'] = array('Notifier', 'UserFiles');
/* install Notifier */
class Notifier {
  // array of: event => path. path can be string, array (of strings and/or false's) or false
  // (to disable logging). strings that end on '/' or '\' get event name + logFileExt appended.
  // '*' works for every event for which no specific entry existed (same with $emails below).
  static $paths = array('*' => 'logs/');
  static $logFileExt = '.log';    // with leading period (if any).
  // array of: event => e-mails. e-mails can be string, array (of strings and/or false's) or false.
  static $emails = array('*' => array('you@us'));

  static function ToFile($event, $title, $vars) {
    foreach (self::GetListOf('paths', $event) as $path) {
      if ($path) {
        if (substr($path, -1) === '/' or substr($path, 0, -1) === '\\') {
          $path = $path.$event.self::$logFileExt;
        }

        $path = ToAbsolutePath($path);
        $text = self::FormatTpl($event, $vars + self::CommonVarsForFile($path), 'text');
        if ($text === null) { break; }

        $msg = date('d.m.y H:i')." - [$event] $title: ".trim($text)."\n";
        strpos($text, "\n") and $msg .= "\n";

        MkDirOf($path);
        file_put_contents($path, $msg, FILE_APPEND);
      }
    }
  }

    static function CommonVarsForFile($file) {
      return array('recepientEMail' => $file, 'recepientName' => basename($file));
    }

    static function FormatTpl($event, $vars, $format = null) {
      $formatted = Template::FormatWrapping("email - $event", $vars);
      return $format ? @$formatted[$format] : $formatted;
    }

  static function ToEMail($event, $title, $vars) {
    $attachments = Template::AttachmentsOf($event);

    foreach (self::GetListOf('emails', $event) as $email) {
      EMail::SendFromTemplate($email, $event, $vars, $title);
    }
  }

  static function GetListOf($prop, $event) {
    $all = self::$$prop;
    if (isset( $all[$event] )) {
      return (array) $all[$event];
    } else {
      return (array) $all['*'];
    }
  }

  static function UserFiles() {
    $list = array();

    foreach (self::$paths as $type => $paths) {
      $paths = (array) $paths;
      foreach ($paths as $path) { $list[] = $path; }
    }

    return $list;
  }
}
